---
name: memocard-api
description: 麦喵单词卡开放 API 接口服务，支持卡片和卡组的创建、查询、管理。当用户需要与麦喵单词卡平台交互、批量创建学习卡片、管理卡组内容、获取学习数据时使用此技能。适用于教育工具集成、自动化内容生成、学习数据同步等场景。
---

# 麦喵单词卡 API

麦喵单词卡开放接口服务，提供完整的 HTTP API 用于卡片和卡组管理。

## 快速开始

### 基础信息

- **Base URL**: `https://fc-mp-7c19cdfb-aa09-46b8-af6b-f7b52e3b3d7b.next.bspapp.com/open-api`
- **App ID**: `__UNI__235AE90`

### 认证方式

**用户认证**（需要登录态的接口）:
- `uni-id-token`: 用户登录凭证
- `app-id`: `__UNI__235AE90`

**卡组认证**（操作卡片的接口）:
- `cardGroupToken`: 卡组访问凭证（JWT Token）

### 标准使用流程

```
1. 登录获取 token → POST /login
2. 创建卡组 → POST /createCardGroup  
3. 获取卡组访问凭证 → POST /getCardGroupOpenApiToken
4. 批量创建卡片 → POST /createCard
```

## 核心功能

### 1. 用户管理

- **登录**: `POST /login` - 使用手机号和密码登录
- **获取用户信息**: `POST /getCurrentUser` - 获取当前登录用户详情

### 2. 卡组管理

- **创建卡组**: `POST /createCardGroup` - 创建新卡组，支持设置标题、描述、标签、语言等
- **获取卡组 Token**: `POST /getCardGroupOpenApiToken` - 获取卡组访问凭证
- **重置卡组 Token**: `POST /resetCardGroupOpenApiToken` - 重置卡组访问凭证

### 3. 卡片管理

- **创建卡片**: `POST /createCard` - 向卡组添加卡片，支持正反面内容、图片、备注
- **获取所有卡片**: `POST /getAllCard` - 获取卡组内所有卡片
- **获取不熟悉卡片**: `POST /getAllUnfamiliarCard` - 获取用户标记为不熟悉的卡片

### 4. 学习小组

- **获取成员列表**: `POST /getUserList` - 获取学习小组成员列表

## 资源文件

### 完整 API 文档

详见 [references/api-docs.md](references/api-docs.md) 获取：
- 所有接口详细参数说明
- 请求/响应示例
- 错误码对照表
- 常见错误处理

### 示例代码

**Python SDK 示例**: [scripts/memocard_sdk.py](scripts/memocard_sdk.py)
- 完整的 Python 客户端类
- 包含所有 API 的封装方法
- 可直接使用的代码示例

**cURL 示例**: [scripts/curl_examples.sh](scripts/curl_examples.sh)
- 命令行调用示例
- 方便快速测试接口

## 使用示例

### Python 批量创建卡片

```python
from scripts.memocard_sdk import MemocardAPI

# 初始化并登录
api = MemocardAPI()
api.login("13800138000", "your-password")

# 创建卡组
card_group = api.create_card_group(
    title="英语四级词汇",
    description="大学英语四级核心词汇",
    tags=["英语", "四级", "词汇"],
    language={"front": "en", "back": "zh"}
)

card_group_id = card_group["data"]["id"]

# 获取卡组 Token
token_result = api.get_card_group_token(card_group_id)
card_group_token = token_result["data"]["token"]

# 批量创建卡片
words = [
    ("abandon", "放弃，抛弃"),
    ("ability", "能力，才能"),
    ("absent", "缺席的，不在场的"),
]

for front, back in words:
    api.create_card(
        card_group_token=card_group_token,
        front=front,
        back=back
    )
```

### 直接 HTTP 调用

```bash
# 创建卡片
curl --location --request POST 'https://fc-mp-7c19cdfb-aa09-46b8-af6b-f7b52e3b3d7b.next.bspapp.com/open-api/createCard' \
  --header 'app-id: __UNI__235AE90' \
  --header 'Content-Type: application/json' \
  --data-raw '{
    "front": "Hello",
    "back": "你好",
    "cardGroupToken": "your-token-here"
  }'
```

## 错误处理

### 错误码说明

| 错误码 | 说明 |
|--------|------|
| 0 | 成功 |
| 400 | 参数错误 |
| 401 | 认证失败 |
| 403 | 权限不足 |
| 500 | 服务器内部错误 |

### 常见错误

- `卡片正反面不能为空` - 创建卡片时 front 或 back 参数为空
- `卡组 Token 不能为空` - 创建卡片时未提供 cardGroupToken
- `Token 校验失败` - cardGroupToken 无效或已过期
- `无权限操作` - 当前用户不是卡组的创建者

## 注意事项

1. **App ID 必须**: 所有接口请求都需要在 Header 中携带 `app-id: __UNI__235AE90`
2. **Token 有效期**: 用户登录 token 有过期时间，需要处理续期
3. **卡组 Token**: 是 JWT 格式，包含卡组 ID 和签名信息
4. **图片上传**: 创建卡片时图片 URL 需要是可访问的网络地址
5. **权限控制**: 只有卡组创建者才能获取和重置卡组 Token
6. **频率限制**: 注意 API 调用频率，避免触发限制

## 典型应用场景

- **教育工具集成**: 将麦喵卡片功能集成到教学平台
- **自动化内容生成**: 批量从Excel/CSV导入词汇生成卡片
- **学习数据同步**: 同步学习进度和统计数据
- **内容分发**: 为学生批量创建定制化学习卡组
