# 麦喵开放 API 完整文档

麦喵单词卡开放接口服务，提供卡片和卡组管理的 HTTP API 接口。

## 基础信息

**Base URL**: `https://fc-mp-7c19cdfb-aa09-46b8-af6b-f7b52e3b3d7b.next.bspapp.com/open-api`

---

## 认证机制

### 用户认证（需要登录态的接口）

| Header | 类型 | 说明 |
|--------|------|------|
| `uni-id-token` | string | 用户登录凭证 |
| `app-id` | string | 应用标识（麦喵: `__UNI__235AE90`） |

### 卡组认证（操作卡片的接口）

| Header | 类型 | 说明 |
|--------|------|------|
| `cardGroupToken` | string | 卡组访问凭证（JWT Token） |

---

## 接口列表

### 1. 用户登录

**接口地址**: `POST /login`

**请求头**:
```
app-id: <应用ID>
Content-Type: application/json
```

**请求参数**:
```json
{
  "mobile": "手机号",
  "password": "密码"
}
```

**响应示例**:
```json
{
  "errCode": 0,
  "errMsg": "success",
  "data": {
    "uid": "用户ID",
    "token": "认证token",
    "tokenExpired": 1672531200000
  }
}
```

**错误响应**:
```json
{
  "errCode": 500,
  "errMsg": "手机号不能为空",
  "data": null
}
```

---

### 2. 获取当前用户信息

**接口地址**: `POST /getCurrentUser`

**请求头**:
```
uni-id-token: <用户认证token>
app-id: <应用ID>
Content-Type: application/json
```

**请求参数**: 无

**响应示例**:
```json
{
  "errCode": 0,
  "errMsg": "success",
  "data": {
    "_id": "user123",
    "nickname": "张三",
    "avatar": "https://example.com/avatar.jpg",
    "registerDate": 1640995200000,
    "expirationDate": 1672531200000,
    "role": ["student"],
    "status": 0,
    "points": 1000,
    "experience": 2500,
    "isVip": true,
    "isForeverVip": false,
    "cardGroup": {
      "_id": "cardgroup123",
      "title": "英语基础词汇",
      "description": "适合初学者的英语词汇",
      "total": 100,
      "isPublic": 1,
      "tags": ["英语", "基础"],
      "createUser": {
        "_id": "creator456",
        "nickname": "李老师",
        "avatar": "https://example.com/teacher.jpg",
        "isVip": true
      }
    }
  }
}
```

---

### 3. 创建卡片

向指定卡组添加新卡片。

**接口地址**: `POST /createCard`

**请求头**:
```
app-id: <应用ID>
Content-Type: application/json
```

**请求参数**:
```json
{
  "front": "string",           // 卡片正面内容（必填）
  "back": "string",            // 卡片背面内容（必填）
  "imgs": ["string"],          // 图片URL数组（可选，最多9张）
  "frontNote": "string",       // 正面备注（可选）
  "backNote": "string",        // 背面备注（可选）
  "cardGroupToken": "string"   // 卡组访问凭证（必填）
}
```

**响应示例**:
```json
{
  "errCode": 0,
  "errMsg": "success",
  "data": {
    "id": "659d5c0821821b50afc316db",
    "cardTotal": 10,
    "cardGroupId": "659d5c0821821b50afc316db"
  }
}
```

---

### 4. 获取卡组所有卡片

**接口地址**: `POST /getAllCard`

**请求头**:
```
uni-id-token: <用户认证token>
app-id: <应用ID>
Content-Type: application/json
```

**请求参数**:
```json
{
  "cardGroupId": "卡组ID"
}
```

**响应示例**:
```json
{
  "errCode": 0,
  "errMsg": "success",
  "data": {
    "count": 100,
    "cards": [
      {
        "id": "card123",
        "cardGroupId": "cardgroup123",
        "front": "Hello",
        "back": "你好",
        "imgs": [],
        "frontNote": "英语问候语",
        "backNote": "中文翻译",
        "createDate": 1640995200000,
        "status": 0
      }
    ]
  }
}
```

---

### 5. 获取不熟悉卡片列表

**接口地址**: `POST /getAllUnfamiliarCard`

**请求头**:
```
uni-id-token: <用户认证token>
app-id: <应用ID>
Content-Type: application/json
```

**请求参数**:
```json
{
  "cardGroupId": "卡组ID",
  "onlyIsShow": true,      // 可选，是否只显示可见的卡片，默认true
  "onlyShowToday": false   // 可选，是否只显示今天的不熟悉卡片，默认false
}
```

**响应示例**:
```json
{
  "errCode": 0,
  "errMsg": "success",
  "data": {
    "count": 25,
    "cards": [
      {
        "_id": "unfamiliar123",
        "cardGroupId": "cardgroup123",
        "front": "difficult",
        "back": "困难的",
        "imgs": [],
        "frontNote": "形容词",
        "backNote": "表示困难",
        "createDate": 1640995200000,
        "status": 0
      }
    ]
  }
}
```

---

### 6. 创建卡组

创建新的卡组，需要用户登录态。

**接口地址**: `POST /createCardGroup`

**请求头**:
```
uni-id-token: <用户认证token>
app-id: <应用ID>
Content-Type: application/json
```

**请求参数**:
```json
{
  "title": "string",           // 卡组标题（必填）
  "description": "string",     // 卡组描述（可选）
  "tags": ["string"],          // 标签数组（可选）
  "is_public": 1,              // 是否公开：1-公开，0-私有
  "language": {                // 语言设置（可选）
    "front": "en",             // 正面语言
    "back": "zh"               // 背面语言
  },
  "is_vip": 0                  // 是否VIP卡组：1-是，0-否
}
```

**响应示例**:
```json
{
  "errCode": 0,
  "errMsg": "success",
  "data": {
    "id": "659d5c0821821b50afc316db"
  }
}
```

---

### 7. 重置卡组 Token

重置指定卡组的访问凭证，需要用户登录态且为卡组创建者。

**接口地址**: `POST /resetCardGroupOpenApiToken`

**请求头**:
```
uni-id-token: <用户认证token>
app-id: <应用ID>
Content-Type: application/json
```

**请求参数**:
```json
{
  "cardGroupId": "string"   // 卡组ID（必填）
}
```

**响应示例**:
```json
{
  "errCode": 0,
  "errMsg": "success",
  "data": {
    "cardGroupId": "659d5c0821821b50afc316db",
    "isSuccess": true,
    "openApiSecret": "new_secret_key"
  }
}
```

---

### 8. 获取卡组 Token

获取指定卡组的访问凭证，需要用户登录态且为卡组创建者。

**接口地址**: `POST /getCardGroupOpenApiToken`

**请求头**:
```
uni-id-token: <用户认证token>
app-id: <应用ID>
Content-Type: application/json
```

**请求参数**:
```json
{
  "cardGroupId": "string"   // 卡组ID（必填）
}
```

**响应示例**:
```json
{
  "errCode": 0,
  "errMsg": "success",
  "data": {
    "token": "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9..."
  }
}
```

---

### 9. 获取学习小组成员列表

获取指定学习小组的成员列表，需要用户登录态。

**接口地址**: `POST /getUserList`

**请求头**:
```
uni-id-token: <用户认证token>
app-id: <应用ID>
Content-Type: application/json
```

**请求参数**:
```json
{
  "learningGroupId": "string",   // 学习小组ID（必填）
  "page": 1,                     // 页码，默认1（可选）
  "userStatus": "join",          // 用户状态：join(已加入)/audit(待审核)/reject(拒绝)
  "pageSize": 500                // 每页数量，默认500（可选）
}
```

**响应示例**:
```json
{
  "errCode": 0,
  "errMsg": "success",
  "data": {
    "total": 150,
    "list": [
      {
        "userId": "user123",
        "learningGroupId": "group456",
        "source": "join",
        "status": 0,
        "createDate": 1672531200000,
        "updateDate": 1672531200000,
        "user": {
          "_id": "user123",
          "nickname": "张三",
          "avatar": "https://example.com/avatar.jpg",
          "expirationDate": 1672531200000,
          "points": 100,
          "experience": 500,
          "isVip": true
        }
      }
    ]
  }
}
```

**状态说明**:
- `status`: 0=已加入, 1=已退出, 2=待审核, 3=审核拒绝
- `source`: 来源，create=创建者, join=加入者
- `isVip`: 是否VIP用户（根据expirationDate自动计算）

---

## 错误码说明

| 错误码 | 说明 |
|--------|------|
| 0 | 成功 |
| 500 | 服务器内部错误 |
| 401 | 认证失败 |
| 403 | 权限不足 |
| 400 | 参数错误 |

---

## 常见错误信息

| 错误信息 | 原因 |
|----------|------|
| `卡片正反面不能为空` | 创建卡片时front或back参数为空 |
| `卡组 Token 不能为空` | 创建卡片时未提供cardGroupToken |
| `Token 校验失败` | cardGroupToken无效或已过期 |
| `卡组不存在` | 指定的卡组ID不存在 |
| `无权限操作` | 当前用户不是卡组的创建者 |
| `卡组未开启 openApi` | 卡组未生成openApiSecret |

---

## 使用流程

```
1. 用户登录 → 获取 uni-id-token
2. 创建卡组 → 使用 /createCardGroup 接口
3. 获取卡组Token → 使用 /getCardGroupOpenApiToken 接口
4. 创建卡片 → 使用 /createCard 接口向卡组添加卡片
5. Token管理 → 如需重置Token，使用 /resetCardGroupOpenApiToken 接口
```

---

## 注意事项

- 所有接口都需要正确的 `app-id` 请求头（麦喵: `__UNI__235AE90`）
- 卡组Token是JWT格式，包含卡组ID和签名信息
- 图片URL需要是可访问的网络地址，系统会自动下载并存储
- 单次创建卡片最多可上传9张图片
- 只有卡组的创建者才能获取和重置卡组Token
