#!/bin/bash
# 麦喵 API cURL 示例脚本
# 演示如何使用命令行调用麦喵开放 API

BASE_URL="https://fc-mp-7c19cdfb-aa09-46b8-af6b-f7b52e3b3d7b.next.bspapp.com/open-api"
APP_ID="__UNI__235AE90"

# 颜色定义
GREEN='\033[0;32m'
RED='\033[0;31m'
NC='\033[0m' # No Color

echo "=========================================="
echo "麦喵 API cURL 示例脚本"
echo "=========================================="
echo ""

# 1. 用户登录
echo -e "${GREEN}1. 用户登录${NC}"
curl --location --request POST "${BASE_URL}/login" \
  --header "app-id: ${APP_ID}" \
  --header "Content-Type: application/json" \
  --data-raw '{
    "mobile": "13800138000",
    "password": "your-password"
  }'
echo -e "\n\n"

# 2. 获取当前用户信息（需要先登录获取 token）
echo -e "${GREEN}2. 获取当前用户信息${NC}"
echo "注意: 需要替换 <your-token> 为实际登录获取的 token"
curl --location --request POST "${BASE_URL}/getCurrentUser" \
  --header "uni-id-token: <your-token>" \
  --header "app-id: ${APP_ID}" \
  --header "Content-Type: application/json"
echo -e "\n\n"

# 3. 创建卡组
echo -e "${GREEN}3. 创建卡组${NC}"
echo "注意: 需要替换 <your-token> 为实际登录获取的 token"
curl --location --request POST "${BASE_URL}/createCardGroup" \
  --header "uni-id-token: <your-token>" \
  --header "app-id: ${APP_ID}" \
  --header "Content-Type: application/json" \
  --data-raw '{
    "title": "英语基础词汇",
    "description": "适合初学者的英语词汇",
    "tags": ["英语", "基础", "词汇"],
    "is_public": 1,
    "language": {
      "front": "en",
      "back": "zh"
    },
    "is_vip": 0
  }'
echo -e "\n\n"

# 4. 获取卡组 Token
echo -e "${GREEN}4. 获取卡组 Token${NC}"
echo "注意: 需要替换 <your-token> 和 <card-group-id>"
curl --location --request POST "${BASE_URL}/getCardGroupOpenApiToken" \
  --header "uni-id-token: <your-token>" \
  --header "app-id: ${APP_ID}" \
  --header "Content-Type: application/json" \
  --data-raw '{
    "cardGroupId": "<card-group-id>"
  }'
echo -e "\n\n"

# 5. 创建卡片
echo -e "${GREEN}5. 创建卡片${NC}"
echo "注意: 需要替换 <card-group-token>"
curl --location --request POST "${BASE_URL}/createCard" \
  --header "app-id: ${APP_ID}" \
  --header "Content-Type: application/json" \
  --data-raw '{
    "front": "Hello",
    "back": "你好",
    "imgs": [],
    "frontNote": "英语问候语",
    "backNote": "中文翻译",
    "cardGroupToken": "<card-group-token>"
  }'
echo -e "\n\n"

# 6. 获取卡组所有卡片
echo -e "${GREEN}6. 获取卡组所有卡片${NC}"
echo "注意: 需要替换 <your-token> 和 <card-group-id>"
curl --location --request POST "${BASE_URL}/getAllCard" \
  --header "uni-id-token: <your-token>" \
  --header "app-id: ${APP_ID}" \
  --header "Content-Type: application/json" \
  --data-raw '{
    "cardGroupId": "<card-group-id>"
  }'
echo -e "\n\n"

# 7. 获取不熟悉卡片列表
echo -e "${GREEN}7. 获取不熟悉卡片列表${NC}"
echo "注意: 需要替换 <your-token> 和 <card-group-id>"
curl --location --request POST "${BASE_URL}/getAllUnfamiliarCard" \
  --header "uni-id-token: <your-token>" \
  --header "app-id: ${APP_ID}" \
  --header "Content-Type: application/json" \
  --data-raw '{
    "cardGroupId": "<card-group-id>",
    "onlyIsShow": true,
    "onlyShowToday": false
  }'
echo -e "\n\n"

# 8. 重置卡组 Token
echo -e "${GREEN}8. 重置卡组 Token${NC}"
echo "注意: 需要替换 <your-token> 和 <card-group-id>"
curl --location --request POST "${BASE_URL}/resetCardGroupOpenApiToken" \
  --header "uni-id-token: <your-token>" \
  --header "app-id: ${APP_ID}" \
  --header "Content-Type: application/json" \
  --data-raw '{
    "cardGroupId": "<card-group-id>"
  }'
echo -e "\n\n"

echo "=========================================="
echo "示例脚本执行完成"
echo "=========================================="
